
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DBD.View
{
    internal class Student : PI.FM.N000.Base.BL.DBD.BaseTable<BO.View.Student>
    {
        #region Static factory
        private static Student _factory = null;

        public static Student DBD
        {
            get
            {
                if (_factory == null)
                {
                    _factory = new Student();
                }
                return _factory;
            }
        }
        #endregion

        #region Override - Initialization
        protected override void InitializeTableName()
        {
            _tableName = "PIZB1200_StudentView";
        }

        protected override void InitializeProperties()
        {
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("UserID", "UserID", true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Email", "Email", true));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("IndexNr", "IndexNr"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("ClassID", "ClassID", true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Forename", "Forename", true));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("Surename", "Surename", true));
            Add(new PI.FM.N000.Base.BL.DBD.BoolProperty("Sex", "Sex"));

            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CurrentAdvancedLevelID", "CurrentAdvancedLevelID"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CurrentEvaluationSheetID", "CurrentEvaluationSheetID"));

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePointsByWeight", "CompetencePointsByWeight"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetenceMaxPoints", "CompetenceMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("CompetenceEvaluationSheetID", "CompetenceEvaluationSheetID"));

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyPoints", "CaseStudyPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CaseStudyMaxPoints", "CaseStudyMaxPoints"));

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("AdvancedTestStartPoints", "AdvancedTestStartPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("AdvancedTestStartMaxPoints", "AdvancedTestStartMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("AdvancedTestStartEvaluationSheetID", "AdvancedTestStartEvaluationSheetID"));

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("AdvancedTestEndPoints", "AdvancedTestEndPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("AdvancedTestEndMaxPoints", "AdvancedTestEndMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("AdvancedTestEndEvaluationSheetID", "AdvancedTestEndEvaluationSheetID"));

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("KnowledgeTestStartPoints", "KnowledgeTestStartPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("KnowledgeTestStartMaxPoints", "KnowledgeTestStartMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("KnowledgeTestStartAdvancedLevelID", "KnowledgeTestStartAdvancedLevelID"));

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("KnowledgeTestEndPoints", "KnowledgeTestEndPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("KnowledgeTestEndMaxPoints", "KnowledgeTestEndMaxPoints"));
            Add(new PI.FM.N000.Base.BL.DBD.LongProperty("KnowledgeTestEndAdvancedLevelID", "KnowledgeTestEndAdvancedLevelID"));

            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("Salary", "Salary"));
            Add(new PI.FM.N000.Base.BL.DBD.DecimalProperty("GameCash", "GameCash"));

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("ResetCount", "ResetCount"));
            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("CompetencePartDone", "CompetencePartDone"));

            Add(new PI.FM.N000.Base.BL.DBD.IntProperty("Flags", "Flags"));

            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("ClassName", "ClassName"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("SchoolName", "SchoolName"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("SchoolYear", "SchoolYear"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("InstructorForename", "InstructorForename"));
            Add(new PI.FM.N000.Base.BL.DBD.StringProperty("InstructorSurename", "InstructorSurename"));

        }
        #endregion

        #region Commands definition
        public enum Commands
        {
            RestoreBySearch = 10,
        }
        #endregion

        #region Get Commands
        protected override Gemini.Core.BL.Interface.DBD.ICommand DoGetCommand(int CommandID)
        {
            switch (CommandID)
            {
                case (int)Commands.RestoreBySearch: return new Command_RestoreBySearch();
            }

            return base.DoGetCommand(CommandID);
        }
        #endregion

        #region Additional Commands Classes
        class Command_RestoreBySearch : PI.FM.N000.Base.BL.DBD.BaseCommand<BO.View.Student>
        {
            public Command_RestoreBySearch() : base(PI.ZB.N1200.ELearning.BL.DBD.View.Student.DBD, Gemini.Core.BL.DBD.CommandType.StoredProcedure) { }

            protected override void InitializeParametrs()
            {
                Add(new Gemini.Core.BL.DBD.Param("SchoolID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("SchoolYearID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("InstructorID", Gemini.Core.BL.DAL.SqlTypes.BigInt));
                Add(new Gemini.Core.BL.DBD.Param("ClassID", Gemini.Core.BL.DAL.SqlTypes.BigInt));

                Add(new Gemini.Core.BL.DBD.Param("Forename", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
                Add(new Gemini.Core.BL.DBD.Param("Surename", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
                Add(new Gemini.Core.BL.DBD.Param("Email", Gemini.Core.BL.DAL.SqlTypes.NVarChar));
            }

            protected override void InitializeCommandText()
            {
                _commandText = "PIZB1200_StudentView_RestoreBySearch";
            }
        }
        #endregion
    }
}